package com.example.bytesbee.alphabets.activities;

import android.app.Application;
import android.speech.tts.TextToSpeech;

import com.example.bytesbee.alphabets.activities.utils.ApplicationLifecycleManager;
import com.example.bytesbee.alphabets.activities.utils.Utils;

import java.util.Locale;

/**
 * Staring point of Android application to initialize the entities, variables, etc.
 *
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class UIApplication extends Application {
    private static TextToSpeech tts;

    @Override
    public void onCreate() {
        super.onCreate();
        registerActivityLifecycleCallbacks(new ApplicationLifecycleManager());
        tts = new TextToSpeech(this, status -> {
            if (status != TextToSpeech.ERROR) {
                tts.setLanguage(Locale.US);
                tts.setPitch(0.9f);
                tts.setSpeechRate(0.6f);

            }
        });
    }

    public static void speak(String value) {
        try {
            tts.speak(value, TextToSpeech.QUEUE_FLUSH, null, null);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

}